//EnergyLogger software part of OpenEnergyMonitor.org project

/*
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//Author: Trystan Lea

//Main program class

import java.awt.*; 
import javax.swing.*;
import java.math.*;
import java.awt.geom.*; 
import java.awt.event.*; 

public class Program
{

//Verbose settings
public static int outputData = 1;
public static int outputStatus = 1;

//Declares the Arduino object field
public static ArduinoComm myArduino;

public static Frame myFrame;

   public static Graph myGraph1;
   public static GCanvas myCanvas;

   public static DataSet[] set;

   public static MyMouseListener mList;
   public static MyMouseWheelListener mWList;
   public static MyMouseMotionListener mMList;

   //Main method
   public static void main(String args[]) 
   {

      myFrame = new Frame();
      myFrame.setBounds(0,0,800,500);
      
      //Create graphing area
      myCanvas = new GCanvas();
      myFrame.con.add(myCanvas); 
      myCanvas.setBounds(145, 5, 645, 460); 
      myFrame.setVisible(true);

      //Create graph in graphing area
      myGraph1 = new Graph("Graph:",145,5,645,460);

      //Set graph x-axis range
      myGraph1.xAxisRange(0,600);
      //Set graph y-axis range
      myGraph1.yAxisRange(0.0,1024.0);

      //Load in/create a data set
      set = new DataSet[6];
      for (int i=0; i<6; i++)
      {
         set[i] = new DataSet(600);
      }
      update();

      //A canvas object has a mouse listener
      mList = new MyMouseListener();
      mMList = new MyMouseMotionListener();
      mWList = new MyMouseWheelListener();

      myCanvas.addMouseListener(mList);
      myCanvas.addMouseMotionListener(mMList);
      myCanvas.addMouseWheelListener(mWList);

      //Add the graphing area to the frame
      //myFrame.con.add(myCanvas);

      //Add buttons
      //Add graphing

      myArduino = new ArduinoComm();

      myArduino.listPorts();

   }

   //Draw, redraw, update graphs
   public static void update()
   {

      
      
      myCanvas.startDraw();

      myGraph1.gCon = myCanvas.offGraphics;

      myGraph1.drawGraph();

      for (int i=0; i<6; i++)
      {
         myGraph1.indexPlot(set[i]);     
      }

      myGraph1.drawText("Mean: ",set[0].mean(), "", 5,40);
      myGraph1.drawText("SD: ",set[0].stdev(), "", 5,80);
      
   }

}


class DataSet
{
   public int index;
   public int staticIndex;
   public int size = 600;
   public int[] vector;

   public DataSet(int _size)
   {
      size = _size;
      vector = new int[size+1];
      index = 0;
   }

   public void addPoint(int value)
   {
      
      vector[index] = value; 
      index++;     
   }
 
   public void resetIndex() {staticIndex=index; index = 0;}

   public double mean()
   {
      long sum=0;

      for (int i=0; i<staticIndex; i++)
      {
         sum = sum + vector[i];
      }
      double mean = 1.0*sum / staticIndex;
      return mean;
   }

   public double stdev()
   {
       double Sum = 0;
       double Sum_sqr = 0;
       double standardDeviation=0;
       
       if (staticIndex>0)
       {
          for(int i=0; i<staticIndex; i++)
          { 
             Sum = Sum + vector[i];
             Sum_sqr = Sum_sqr + (vector[i]*vector[i]);
          }

       double mean = Sum/staticIndex;
       
       standardDeviation = Math.sqrt((Sum_sqr - Sum*mean)/(staticIndex));
       }
       return standardDeviation;
   }

}



class MyMouseListener extends MouseAdapter {
   public void mousePressed(MouseEvent e)
   {
      Program.mMList.mxD = e.getX();
      Program.mMList.myD = e.getY();
      if (Program.outputStatus==1){System.out.println("Mouse pressed");}
   }
   public void mouseReleased(MouseEvent e){ 
     if (Program.outputStatus==1){System.out.println("Mouse Released");}
   }
   public void mouseClicked(MouseEvent e){
     if (Program.outputStatus==1){System.out.println("Mouse Clicked");}
   }
}

class MyMouseWheelListener implements MouseWheelListener {
   public void mouseWheelMoved(MouseWheelEvent e) 
   {
      double wrot = 1.0+e.getWheelRotation()*0.01;
      //double wrot = 1.0;
      if (Program.myGraph1.select == 1)
      {
         Program.myGraph1.zoomx(wrot);
         Program.myGraph1.zoomy(wrot);
      }

Program.update(); 
   }
}

class MyMouseMotionListener extends MouseMotionAdapter 
{

public int mxD,myD,lmxD,lmyD;
int mxM,myM;

   public void mouseDragged(MouseEvent e)
   { 
      lmxD=mxD;
      lmyD=myD;
      mxD = e.getX(); 
      myD = e.getY();

      int mmx = mxD - lmxD;
      int mmy = myD - lmyD;
      
      if (Program.myGraph1.select == 1)
      {
         Program.myGraph1.movex(mmx);
         Program.myGraph1.movey(mmy);
      }
      Program.update(); 
   }

   public void mouseMoved(MouseEvent e){
      mxM = e.getX(); 
      myM = e.getY();

      
      //Check if mouse is withing bounds of a graph 
      //If it is "select" the graph.
      //Graph1
      Program.update(); 
      if (Program.myGraph1.pointInBounds(mxM,myM)==true)
      {   
         Program.myGraph1.select();
      }
      else 
      {
         Program.myGraph1.deselect();
      }
  }  
}


